/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.export.csv;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import cz.insophy.inplan.export.TableWriter;
import cz.insophy.inplan.export.csv.CsvFormat;
import cz.insophy.inplan.export.csv.CsvFormatter;
import cz.insophy.inplan.report.ReportUtilities;
import cz.insophy.inplan.superplan.GeneralizedRequest;
import cz.insophy.inplan.util.Formatter;
import java.awt.Color;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.csv.CSVPrinter;

public class CsvTableWriter
extends TableWriter {
    private final CsvFormatter formatter;
    protected final CSVPrinter writer;
    protected final List<String> currentRow;
    private boolean firstSheetOpened;

    public static CsvTableWriter createWriter(File target, CsvFormat format) throws IOException {
        return format.createWriter(new FileOutputStream(target));
    }

    public static CsvTableWriter createWriter(OutputStream target, CsvFormat format) throws IOException {
        return format.createWriter(target);
    }

    CsvTableWriter(CSVPrinter writer, CsvFormatter formatter) {
        this.writer = writer;
        this.formatter = formatter;
        this.currentRow = Lists.newArrayListWithCapacity(20);
        this.firstSheetOpened = false;
    }

    @Override
    public void newSheet(String title) {
        Preconditions.checkState(!this.firstSheetOpened, "CSV does not support more than one sheet.");
        this.firstSheetOpened = true;
    }

    @Override
    public boolean newRow() {
        Preconditions.checkState(this.firstSheetOpened);
        try {
            this.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    public void newRow(String ... values) {
        this.newRow();
        for (String value : values) {
            this.newCell(value);
        }
    }

    public void newCell(String value) {
        if (value == null) {
            this.currentRow.add("");
        } else {
            this.currentRow.add(value);
        }
    }

    @Override
    public void newHeaderCell(String title) {
        this.newCell(title);
    }

    @Override
    public void newStringCell(String value, TableWriter.CellProperties props) {
        this.newCell(value == null ? null : ReportUtilities.stripHtml(value));
    }

    @Override
    public void newDateCell(Long date, TableWriter.CellProperties props) {
        if (date == null || !GeneralizedRequest.isDateValid(date)) {
            this.newEmptyCell(props);
        } else {
            LocalDateTime ldt = LocalDateTime.ofInstant(Instant.ofEpochMilli(date), ZoneId.systemDefault());
            this.newCell(this.formatter.formatDate(ldt.toLocalDate()));
        }
    }

    @Override
    public void newDatetimeCell(Long date, TableWriter.CellProperties props) {
        if (date == null || !GeneralizedRequest.isDateValid(date)) {
            this.newEmptyCell(props);
        } else {
            LocalDateTime ldt = LocalDateTime.ofInstant(Instant.ofEpochMilli(date), ZoneId.systemDefault());
            this.newCell(this.formatter.formatDatetime(ldt));
        }
    }

    @Override
    public void newTimeCell(Long date, TableWriter.CellProperties props) {
        if (date == null || !GeneralizedRequest.isDateValid(date)) {
            this.newEmptyCell(props);
        } else {
            LocalDateTime ldt = LocalDateTime.ofInstant(Instant.ofEpochMilli(date), ZoneId.systemDefault());
            this.newCell(this.formatter.formatTime(ldt.toLocalTime()));
        }
    }

    @Override
    public void newDurationInDayCell(Long duration, TableWriter.CellProperties props) {
        if (duration == null || !GeneralizedRequest.isDateValid(duration)) {
            this.newEmptyCell(props);
        } else {
            this.newCell(Formatter.formatDurationDay(duration));
        }
    }

    @Override
    public void newDurationInHourCell(Long duration, TableWriter.CellProperties props) {
        if (duration == null || !GeneralizedRequest.isDateValid(duration)) {
            this.newEmptyCell(props);
        } else {
            this.newCell(Formatter.formatDurationHour(duration));
        }
    }

    @Override
    public void newDurationCell(Long duration, TableWriter.CellProperties props) {
        if (duration == null || !GeneralizedRequest.isDateValid(duration)) {
            this.newEmptyCell(props);
        } else {
            this.newCell(Formatter.formatDuration(duration));
        }
    }

    @Override
    public void newBooleanCell(Boolean value, TableWriter.CellProperties props) {
        if (value == null) {
            this.newEmptyCell(props);
        } else {
            this.newCell(value != false ? Formatter.getSymbols().getBooleanTrue() : Formatter.getSymbols().getBooleanFalse());
        }
    }

    @Override
    public boolean canWriteStatistics() {
        return false;
    }

    @Override
    public void addStatisticsFormula(TableWriter.ColumnStatisticsType type) {
        throw new IllegalStateException("Cannot export statistics to CSV");
    }

    @Override
    public void newIntegerCell(Long value, TableWriter.CellProperties props) {
        if (value == null) {
            this.newEmptyCell(props);
        } else {
            this.newCell(this.formatter.formatNumber(value.longValue()));
        }
    }

    @Override
    public void newFloatCell(Double value, TableWriter.CellProperties props) {
        if (value == null) {
            this.newEmptyCell(props);
        } else {
            this.newCell(this.formatter.formatNumber(value));
        }
    }

    @Override
    public void newPercentCell(Double value, TableWriter.CellProperties props) {
        if (value == null) {
            this.newEmptyCell(props);
        } else {
            this.newCell(this.formatter.formatPercent(value));
        }
    }

    @Override
    public void newColorCell(Color value, TableWriter.CellProperties props) {
        if (value == null) {
            this.newEmptyCell(props);
        } else {
            this.newCell("#" + Integer.toHexString(value.getRGB()));
        }
    }

    @Override
    public void newEmptyCell(TableWriter.CellProperties props) {
        this.newCell(null);
    }

    @Override
    public void closeWriter() throws IOException {
        this.flush();
        this.writer.close();
    }

    @Override
    public void newNhCell(Long value, TableWriter.CellProperties props) {
        if (value == null) {
            this.newEmptyCell(props);
        } else {
            this.newCell(Formatter.formatDurationNh(value));
        }
    }

    @Override
    public boolean addMultipleLinks(@Nonnull List<TableWriter.CellLink> links) {
        return false;
    }

    @Override
    public void addLink(@Nonnull String absoluteUrl, @Nullable TableWriter.CellProperties props) {
        try {
            this.addDescription(absoluteUrl, false);
        }
        catch (Exception e) {
            this.addError("Error adding link", "Failed to add URL:'" + absoluteUrl + "', " + e.getMessage());
        }
    }

    @Override
    public void addDescription(String text, boolean useMonospaceFont) {
        if (useMonospaceFont) {
            return;
        }
        text = ReportUtilities.stripHtml(Strings.nullToEmpty(text));
        int i = this.currentRow.size() - 1;
        Object s2 = this.currentRow.get(i);
        this.currentRow.remove(i);
        if (Strings.isNullOrEmpty((String)s2)) {
            s2 = text;
        } else if (!text.isEmpty()) {
            s2 = (String)s2 + " (" + text + ")";
        }
        this.newCell((String)s2);
    }

    public void flush() throws IOException {
        if (!this.currentRow.isEmpty()) {
            this.writer.printRecord(this.currentRow);
        }
        this.writer.flush();
        this.currentRow.clear();
    }
}

